/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.route;

import com.ms.studio.service.RssService;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Component
public class MsRssPluginRouteEndpoint {
    private final RssService rssService;

    @Bean
    RouterFunction<ServerResponse> sitemapRouterFunction() {
        RequestPredicate requestPredicate = RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.TEXT_XML, MediaType.APPLICATION_RSS_XML});
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/feed.xml").and(requestPredicate), this.rssService::allRss).andRoute(RequestPredicates.GET((String)"/feed").and(requestPredicate), this.rssService::allRss).andRoute(RequestPredicates.GET((String)"/rss").and(requestPredicate), this.rssService::allRss).andRoute(RequestPredicates.GET((String)"/rss.xml").and(requestPredicate), this.rssService::allRss).andRoute(RequestPredicates.GET((String)"/feed/categories/{category}.xml").and(requestPredicate), request -> this.rssService.categoryFeed(request, request.pathVariable("category"))).andRoute(RequestPredicates.GET((String)"/feed/authors/{author}.xml").and(requestPredicate), request -> this.rssService.authorFeed(request, request.pathVariable("author"))).andRoute(RequestPredicates.GET((String)"/rss/categories/{category}").and(requestPredicate), request -> this.rssService.categoryFeed(request, request.pathVariable("category"))).andRoute(RequestPredicates.GET((String)"/rss/authors/{author}").and(requestPredicate), request -> this.rssService.authorFeed(request, request.pathVariable("author")));
    }

    public MsRssPluginRouteEndpoint(RssService rssService) {
        this.rssService = rssService;
    }
}

